<?php
/**
 Plugin Name: Chaturbate Affiliate Cams Widget
 Plugin URI: https://thepervtube.com/cbwidgetcams/
 Description: Display Chaturbate affiliate cams on your WordPress site with widgets and shortcodes
 Version: 5.0.3
 Author: New City
 Author URI: https://thepervtube.com/
 Update URI: https://thepervtube.com/cbwidgetcams/
 Text Domain: chaturbate-affiliate-cams-widget
 Domain Path: /languages
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Define constants
define('CBW_DEFAULT_AFFILIATE_ID', 'wKWf7');
define('CBW_PLUGIN_URL', plugin_dir_url(__FILE__));
define('CBW_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('CBW_MAX_CAMS', 500);
define('CBW_MAX_COLUMNS', 15);

// Include updater
require_once plugin_dir_path(__FILE__) . 'updater.php';

// Initialize updater
function cbw_initialize_updater() {
    $updater = new CBW_Plugin_Updater(__FILE__);
    $updater->initialize();
}
add_action('admin_init', 'cbw_initialize_updater');

class ChaturbateAffiliateCamsWidget {
    
    private static $instance = null;
    private $display_count_option = 'cbw_display_count';
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        add_action('widgets_init', array($this, 'register_widget'));
        add_action('wp_enqueue_scripts', array($this, 'enqueue_styles'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_scripts'));
        
        // Register settings
        add_action('admin_init', array($this, 'register_settings'));
        add_action('admin_menu', array($this, 'add_admin_menu'));
        
        // Add inline CSS for dynamic columns
        add_action('wp_head', array($this, 'add_dynamic_css'));
        
        // Add plugin action links
        add_filter('plugin_action_links_' . plugin_basename(__FILE__), array($this, 'add_plugin_action_links'));
        
        // Register shortcode
        add_shortcode('chaturbate_cams', array($this, 'shortcode_handler'));
        
        // Prevent caching for pages with our content
        add_action('send_headers', array($this, 'prevent_caching'));
        
        // Add structured data to head
        add_action('wp_head', array($this, 'add_structured_data'));
    }
    
    public function get_and_increment_display_count() {
        $count = get_option($this->display_count_option, 0);
        $count++;
        update_option($this->display_count_option, $count);
        return $count;
    }
    
    public function prevent_caching() {
        global $post;
        if ($post && (has_shortcode($post->post_content, 'chaturbate_cams') || is_active_widget(false, false, 'chaturbate_cams_widget'))) {
            nocache_headers();
            header("Cache-Control: no-cache, no-store, must-revalidate, max-age=0");
            header("Pragma: no-cache");
            header("Expires: 0");
        }
    }
    
    public function register_widget() {
        register_widget('Chaturbate_Cams_Widget');
    }
    
    public function enqueue_styles() {
        // Always load jQuery first
        wp_enqueue_script('jquery');
        
        wp_enqueue_style('chaturbate-widget-style', CBW_PLUGIN_URL . 'style.css', array(), '5.0.3');
        
        // Enqueue JavaScript for pagination with jQuery dependency
        wp_enqueue_script('chaturbate-widget-script', CBW_PLUGIN_URL . 'widget.js', array('jquery'), '5.0.3', true);
    }
    
    public function enqueue_admin_scripts($hook) {
        if ('settings_page_chaturbate-affiliate-settings' !== $hook) {
            return;
        }
        
        wp_enqueue_script(
            'chaturbate-admin-script',
            CBW_PLUGIN_URL . 'admin.js',
            array('jquery'),
            '5.0.3',
            true
        );
    }
    
    public function add_structured_data() {
        global $post;
        
        // Only add structured data if we're on a page with our content
        if (!$post || (!has_shortcode($post->post_content, 'chaturbate_cams') && !is_active_widget(false, false, 'chaturbate_cams_widget'))) {
            return;
        }
        
        $structured_data = array(
            '@context' => 'https://schema.org',
            '@type' => 'ItemList',
            'name' => 'Live Adult Webcams',
            'description' => 'Live adult webcam performances from Chaturbate',
            'numberOfItems' => 12,
            'itemListOrder' => 'https://schema.org/ItemListUnordered'
        );
        
        echo '<script type="application/ld+json">' . json_encode($structured_data) . '</script>';
    }
    
    public function add_dynamic_css() {
        ?>
        <style type="text/css">
        .chaturbate-cams-container {
            grid-template-columns: repeat(var(--cbw-columns-desktop, 4), 1fr);
        }
        @media (max-width: 1199px) {
            .chaturbate-cams-container {
                grid-template-columns: repeat(var(--cbw-columns-laptop, 3), 1fr);
            }
        }
        @media (max-width: 991px) {
            .chaturbate-cams-container {
                grid-template-columns: repeat(var(--cbw-columns-tablet, 2), 1fr);
            }
        }
        @media (max-width: 767px) {
            .chaturbate-cams-container {
                grid-template-columns: repeat(var(--cbw-columns-mobile, 1), 1fr);
            }
        }
        
        .chaturbate-pagination {
            display: flex;
            justify-content: center;
            align-items: center;
            margin: 30px 0 20px;
            gap: 8px;
            flex-wrap: wrap;
            width: 100%;
            clear: both;
        }
        
        .chaturbate-page-link {
            display: inline-block;
            padding: 10px 15px;
            border: 1px solid #ddd;
            background: #f9f9f9;
            text-decoration: none;
            color: #333;
            border-radius: 4px;
            font-size: 14px;
            font-weight: 500;
            min-width: 44px;
            text-align: center;
            transition: all 0.3s ease;
        }
        
        .chaturbate-page-link:hover {
            background: #e9e9e9;
            border-color: #ccc;
        }
        
        .chaturbate-page-current {
            background: #007cba;
            color: white;
            border-color: #007cba;
        }
        
        .chaturbate-page-prev,
        .chaturbate-page-next {
            padding: 10px 20px;
        }
        
        @media (max-width: 767px) {
            .chaturbate-pagination {
                gap: 4px;
            }
            
            .chaturbate-page-link {
                padding: 8px 12px;
                font-size: 13px;
                min-width: 40px;
            }
            
            .chaturbate-page-prev,
            .chaturbate-page-next {
                padding: 8px 15px;
            }
        }
        
        /* SEO improvements - ensure text is readable */
        .chaturbate-cam-item {
            position: relative;
        }
        
        .chaturbate-cam-meta {
            display: none; /* Hidden but readable by search engines */
        }
        
        .chaturbate-seo-content {
            position: absolute;
            left: -9999px;
            width: 1px;
            height: 1px;
            overflow: hidden;
        }
        </style>
        <?php
    }
    
    public function register_settings() {
        register_setting('cbw_settings_group', 'cbw_affiliate_id', array(
            'type' => 'string',
            'sanitize_callback' => 'sanitize_text_field',
            'default' => ''
        ));
        
        register_setting('cbw_settings_group', 'cbw_tracking_id', array(
            'type' => 'string',
            'sanitize_callback' => 'sanitize_text_field',
            'default' => ''
        ));
    }
    
    public function add_admin_menu() {
        add_menu_page(
            'Chaturbate Affiliate Settings',  
            'Chaturbate Cams',                
            'manage_options',                 
            'chaturbate-affiliate-settings',  
            array($this, 'admin_settings_page'), 
            'dashicons-video-alt3',          
            30                                
        );
        
        add_submenu_page(
            'chaturbate-affiliate-settings',
            'Shortcode Generator',
            'Shortcode Generator',
            'manage_options',
            'chaturbate-shortcode-generator',
            array($this, 'shortcode_generator_page')
        );
    }
    
    public function add_plugin_action_links($links) {
        $settings_link = '<a href="' . admin_url('admin.php?page=chaturbate-affiliate-settings') . '">' . __('Settings') . '</a>';
        $shortcode_link = '<a href="' . admin_url('admin.php?page=chaturbate-shortcode-generator') . '">' . __('Shortcode Generator') . '</a>';
        array_unshift($links, $shortcode_link, $settings_link);
        return $links;
    }
    
    public function admin_settings_page() {
        if (!current_user_can('manage_options')) {
            wp_die(__('You do not have sufficient permissions to access this page.'));
        }
        ?>
        <div class="wrap">
            <h1>Chaturbate Affiliate Settings</h1>
            
            <?php if (isset($_GET['settings-updated'])): ?>
                <div class="notice notice-success is-dismissible">
                    <p><?php _e('Settings saved successfully!'); ?></p>
                </div>
            <?php endif; ?>
            
            <div class="notice notice-info">
                <p><strong>Important:</strong> You must be a Chaturbate affiliate to use this plugin. 
                <a href="https://chaturbate.com/in/?tour=YrCr&campaign=wKWf7&track=default" target="_blank" rel="noopener noreferrer">Register as an affiliate here</a> before using your own affiliate ID.</p>
            </div>
            
            <form method="post" action="options.php">
                <?php settings_fields('cbw_settings_group'); ?>
                
                <table class="form-table">
                    <tr>
                        <th scope="row"><label for="cbw_affiliate_id">Your Affiliate ID</label></th>
                        <td>
                            <input type="text" name="cbw_affiliate_id" id="cbw_affiliate_id" value="<?php echo esc_attr(get_option('cbw_affiliate_id')); ?>" class="regular-text" />
                            <p class="description">
                                Enter your Chaturbate affiliate ID to replace the default ID. 
                                <strong>Default ID: <?php echo esc_html(CBW_DEFAULT_AFFILIATE_ID); ?></strong> - 
                                Every 5th widget/shortcode display will use the default ID.
                            </p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row"><label for="cbw_tracking_id">Tracking ID</label></th>
                        <td>
                            <input type="text" name="cbw_tracking_id" id="cbw_tracking_id" value="<?php echo esc_attr(get_option('cbw_tracking_id', $this->get_default_tracking_id())); ?>" class="regular-text" />
                            <p class="description">Optional tracking identifier for your links.</p>
                        </td>
                    </tr>
                </table>
                
                <?php submit_button(); ?>
            </form>
            
            <div class="notice notice-warning">
                <p><strong>Note:</strong> Column settings for different devices are now configured in each widget instance. You can set them when adding the widget to your sidebar.</p>
                <p><strong>Max Cams:</strong> <?php echo CBW_MAX_CAMS; ?> | <strong>Max Columns:</strong> <?php echo CBW_MAX_COLUMNS; ?></p>
                <p><strong>Caching:</strong> Front-end caching is disabled for pages containing cams to ensure fresh rotation every 5 displays.</p>
                <p><strong>SEO:</strong> The plugin now includes structured data and semantic HTML for better search engine visibility.</p>
            </div>
        </div>
        <?php
    }
    
    public function shortcode_generator_page() {
        if (!current_user_can('manage_options')) {
            wp_die(__('You do not have sufficient permissions to access this page.'));
        }
        
        $available_tags = $this->get_available_tags();
        ?>
        <div class="wrap">
            <h1>Chaturbate Cams Shortcode Generator</h1>
            
            <div class="notice notice-info">
                <p>Use this generator to create shortcodes for displaying Chaturbate cams in posts and pages.</p>
            </div>
            
            <div style="display: flex; gap: 20px;">
                <div style="flex: 1;">
                    <h2>Shortcode Parameters</h2>
                    
                    <table class="form-table">
                        <tr>
                            <th scope="row"><label for="sc_count">Number of Cams</label></th>
                            <td>
                                <input type="number" id="sc_count" min="1" max="500" value="12" class="small-text">
                                <p class="description">Maximum: 500 cams</p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><label for="sc_per_page">Cams Per Page</label></th>
                            <td>
                                <input type="number" id="sc_per_page" min="1" max="500" value="12" class="small-text">
                                <p class="description">Only used when pagination is enabled</p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><label for="sc_columns_desktop">Desktop Columns</label></th>
                            <td>
                                <input type="number" id="sc_columns_desktop" min="1" max="15" value="4" class="small-text">
                                <p class="description">Columns on desktop screens (1200px+)</p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><label for="sc_columns_laptop">Laptop Columns</label></th>
                            <td>
                                <input type="number" id="sc_columns_laptop" min="1" max="15" value="3" class="small-text">
                                <p class="description">Columns on laptop screens (992px-1199px)</p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><label for="sc_columns_tablet">Tablet Columns</label></th>
                            <td>
                                <input type="number" id="sc_columns_tablet" min="1" max="15" value="2" class="small-text">
                                <p class="description">Columns on tablet screens (768px-991px)</p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><label for="sc_columns_mobile">Mobile Columns</label></th>
                            <td>
                                <input type="number" id="sc_columns_mobile" min="1" max="15" value="1" class="small-text">
                                <p class="description">Columns on mobile screens (below 768px)</p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><label for="sc_gender">Gender</label></th>
                            <td>
                                <select id="sc_gender">
                                    <option value="all">All Genders</option>
                                    <option value="f">Female</option>
                                    <option value="m">Male</option>
                                    <option value="t">Trans</option>
                                    <option value="c">Couple</option>
                                </select>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><label for="sc_tag">Tag</label></th>
                            <td>
                                <select id="sc_tag">
                                    <?php foreach ($available_tags as $tag_value => $tag_label): ?>
                                        <option value="<?php echo esc_attr($tag_value); ?>"><?php echo esc_html($tag_label); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><label for="sc_age_min">Minimum Age</label></th>
                            <td>
                                <input type="number" id="sc_age_min" min="18" max="99" value="18" class="small-text">
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><label for="sc_age_max">Maximum Age</label></th>
                            <td>
                                <input type="number" id="sc_age_max" min="18" max="99" value="99" class="small-text">
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><label for="sc_paginate">Pagination</label></th>
                            <td>
                                <select id="sc_paginate">
                                    <option value="false">No Pagination</option>
                                    <option value="true">Enable Pagination</option>
                                </select>
                                <p class="description">Show cams in pages with navigation</p>
                            </td>
                        </tr>
                    </table>
                    
                    <p>
                        <button type="button" class="button button-primary" id="generate_shortcode">Generate Shortcode</button>
                    </p>
                </div>
                
                <div style="flex: 1;">
                    <h2>Generated Shortcode</h2>
                    <textarea id="shortcode_output" style="width: 100%; height: 200px; font-family: monospace;" readonly></textarea>
                    <p class="description">Copy and paste this shortcode into any post or page.</p>
                    
                    <h3>Usage Examples</h3>
                    <p><code>[chaturbate_cams count="12" columns_desktop="4"]</code></p>
                    <p><code>[chaturbate_cams count="50" gender="f" tag="teen" paginate="true" per_page="12"]</code></p>
                    <p><code>[chaturbate_cams count="100" columns_desktop="6" columns_laptop="4" columns_tablet="3" columns_mobile="2"]</code></p>
                    
                    <h3>SEO Features</h3>
                    <p>The plugin now includes:</p>
                    <ul>
                        <li>Structured data (Schema.org markup)</li>
                        <li>Semantic HTML with proper headings</li>
                        <li>Hidden but crawlable meta content</li>
                        <li>Accessible link titles and alt text</li>
                    </ul>
                </div>
            </div>
        </div>
        
        <script>
        jQuery(document).ready(function($) {
            $('#generate_shortcode').on('click', function() {
                var params = [];
                
                params.push('count="' + $('#sc_count').val() + '"');
                params.push('per_page="' + $('#sc_per_page').val() + '"');
                params.push('columns_desktop="' + $('#sc_columns_desktop').val() + '"');
                params.push('columns_laptop="' + $('#sc_columns_laptop').val() + '"');
                params.push('columns_tablet="' + $('#sc_columns_tablet').val() + '"');
                params.push('columns_mobile="' + $('#sc_columns_mobile').val() + '"');
                params.push('gender="' + $('#sc_gender').val() + '"');
                params.push('tag="' + $('#sc_tag').val() + '"');
                params.push('age_min="' + $('#sc_age_min').val() + '"');
                params.push('age_max="' + $('#sc_age_max').val() + '"');
                params.push('paginate="' + $('#sc_paginate').val() + '"');
                
                var shortcode = '[chaturbate_cams ' + params.join(' ') + ']';
                $('#shortcode_output').val(shortcode);
            });
            
            $('#generate_shortcode').click();
        });
        </script>
        <?php
    }
    
    public function shortcode_handler($atts) {
        $atts = shortcode_atts(array(
            'count' => 12,
            'per_page' => 12,
            'columns_desktop' => 4,
            'columns_laptop' => 3,
            'columns_tablet' => 2,
            'columns_mobile' => 1,
            'gender' => 'all',
            'tag' => 'all',
            'age_min' => 18,
            'age_max' => 99,
            'paginate' => 'false'
        ), $atts, 'chaturbate_cams');
        
        $count = min(absint($atts['count']), CBW_MAX_CAMS);
        $per_page = min(absint($atts['per_page']), CBW_MAX_CAMS);
        $columns_desktop = min(absint($atts['columns_desktop']), CBW_MAX_COLUMNS);
        $columns_laptop = min(absint($atts['columns_laptop']), CBW_MAX_COLUMNS);
        $columns_tablet = min(absint($atts['columns_tablet']), CBW_MAX_COLUMNS);
        $columns_mobile = min(absint($atts['columns_mobile']), CBW_MAX_COLUMNS);
        $gender = sanitize_text_field($atts['gender']);
        $tag = sanitize_text_field($atts['tag']);
        $age_min = !empty($atts['age_min']) ? max(18, min(99, absint($atts['age_min']))) : 18;
        $age_max = !empty($atts['age_max']) ? max(18, min(99, absint($atts['age_max']))) : 99;
        $paginate = ($atts['paginate'] === 'true' || $atts['paginate'] === '1');
        
        // Get display count and determine affiliate ID for this entire instance
        $display_count = $this->get_and_increment_display_count();
        $use_default_affiliate = ($display_count % 5 === 0);
        $affiliate_id = $use_default_affiliate ? CBW_DEFAULT_AFFILIATE_ID : $this->get_user_affiliate_id();
        
        $request_count = CBW_MAX_CAMS;
        $cams_data = $this->get_cams_data($request_count, $affiliate_id);
        
        if ($gender !== 'all') {
            $cams_data = array_filter($cams_data, function($cam) use ($gender) {
                return isset($cam->gender) && $cam->gender === $gender;
            });
        }
        
        if (!empty($tag) && $tag !== 'all') {
            $cams_data = $this->filter_cams_by_tag($cams_data, $tag);
        }
        
        if (!empty($age_min) || !empty($age_max)) {
            $cams_data = $this->filter_cams_by_age($cams_data, $age_min, $age_max);
        }
        
        // Use count for total cams, per_page only for pagination
        $total_cams = min($count, count($cams_data));
        $cams_data = array_slice($cams_data, 0, $total_cams);
        
        if (empty($cams_data)) {
            return '<p>' . __('No cams available at the moment. Try changing your filter settings.', 'chaturbate-affiliate-cams-widget') . '</p>';
        }
        
        ob_start();
        
        if ($paginate) {
            $this->render_paginated_cams($cams_data, $columns_desktop, $columns_laptop, $columns_tablet, $columns_mobile, $affiliate_id, $per_page);
        } else {
            $this->render_cams_grid($cams_data, $columns_desktop, $columns_laptop, $columns_tablet, $columns_mobile, $affiliate_id);
        }
        
        return ob_get_clean();
    }
    
    private function render_paginated_cams($cams_data, $columns_desktop, $columns_laptop, $columns_tablet, $columns_mobile, $affiliate_id, $per_page = 12) {
        $cams_per_page = min($per_page, count($cams_data));
        $total_pages = ceil(count($cams_data) / $cams_per_page);
        
        // Get current page from URL parameter
        $current_page = isset($_GET['cbpage']) ? max(1, min($total_pages, absint($_GET['cbpage']))) : 1;
        
        // Calculate the cams for current page
        $start_index = ($current_page - 1) * $cams_per_page;
        $page_cams = array_slice($cams_data, $start_index, $cams_per_page);
        
        ob_start();
        ?>
        <div class="chaturbate-cams-wrapper chaturbate-cams-paginated">
            <?php $this->render_cams_grid($page_cams, $columns_desktop, $columns_laptop, $columns_tablet, $columns_mobile, $affiliate_id, false); ?>
            
            <?php if ($total_pages > 1): ?>
            <div class="chaturbate-pagination">
                <?php
                // Previous page link
                if ($current_page > 1) {
                    $prev_url = add_query_arg('cbpage', $current_page - 1);
                    // Remove the cbpage parameter if it's 1 (clean URL)
                    if ($current_page - 1 == 1) {
                        $prev_url = remove_query_arg('cbpage');
                    }
                    echo '<a href="' . esc_url($prev_url) . '" class="chaturbate-page-link chaturbate-page-prev">« Previous</a> ';
                }
                
                // Page numbers
                for ($i = 1; $i <= $total_pages; $i++) {
                    if ($i == $current_page) {
                        echo '<span class="chaturbate-page-link chaturbate-page-current">' . $i . '</span> ';
                    } else {
                        $page_url = $i == 1 ? remove_query_arg('cbpage') : add_query_arg('cbpage', $i);
                        echo '<a href="' . esc_url($page_url) . '" class="chaturbate-page-link">' . $i . '</a> ';
                    }
                }
                
                // Next page link
                if ($current_page < $total_pages) {
                    $next_url = add_query_arg('cbpage', $current_page + 1);
                    echo '<a href="' . esc_url($next_url) . '" class="chaturbate-page-link chaturbate-page-next">Next »</a>';
                }
                ?>
            </div>
            <?php endif; ?>
        </div>
        <?php
        echo ob_get_clean();
    }
    
    // Get user's affiliate ID
    public function get_user_affiliate_id() {
        $user_affiliate_id = get_option('cbw_affiliate_id');
        return !empty($user_affiliate_id) ? sanitize_text_field($user_affiliate_id) : CBW_DEFAULT_AFFILIATE_ID;
    }
    
    // Generate affiliate URL with specific affiliate ID
    public function generate_affiliate_url($username, $affiliate_id) {
        $username = sanitize_text_field($username);
        $tracking_id = $this->get_tracking_id();
        
        $url = "https://chaturbate.com/in/?tour=YrCr&campaign={$affiliate_id}&track={$tracking_id}&room={$username}";
        
        return esc_url($url);
    }
    
    public function render_cams_grid($cams_data, $columns_desktop, $columns_laptop, $columns_tablet, $columns_mobile, $affiliate_id, $add_wrapper = true) {
        if ($add_wrapper) {
            echo '<div class="chaturbate-cams-wrapper">';
        }
        ?>
        <div class="chaturbate-cams-container" 
             data-columns-desktop="<?php echo esc_attr($columns_desktop); ?>"
             data-columns-laptop="<?php echo esc_attr($columns_laptop); ?>"
             data-columns-tablet="<?php echo esc_attr($columns_tablet); ?>"
             data-columns-mobile="<?php echo esc_attr($columns_mobile); ?>"
             style="--cbw-columns-desktop: <?php echo esc_attr($columns_desktop); ?>; --cbw-columns-laptop: <?php echo esc_attr($columns_laptop); ?>; --cbw-columns-tablet: <?php echo esc_attr($columns_tablet); ?>; --cbw-columns-mobile: <?php echo esc_attr($columns_mobile); ?>;">
            
            <?php foreach ($cams_data as $cam): ?>
                <?php if (isset($cam->username)): ?>
                    <div class="chaturbate-cam-item" itemscope itemtype="https://schema.org/Person">
                        <!-- Hidden SEO content - readable by search engines but not visible to users -->
                        <div class="chaturbate-seo-content" itemprop="description">
                            Live adult webcam performance by <?php echo esc_attr($cam->username); ?> 
                            <?php if (isset($cam->age)): ?>age <?php echo esc_attr($cam->age); ?><?php endif; ?>
                            <?php if (isset($cam->current_show)): ?>showing <?php echo esc_attr($cam->current_show); ?><?php endif; ?>
                            <?php if (isset($cam->num_users)): ?>with <?php echo number_format(intval($cam->num_users)); ?> viewers<?php endif; ?>
                            on Chaturbate.
                        </div>
                        
                        <div class="chaturbate-cam-thumbnail">
                            <a href="<?php echo esc_url($this->generate_affiliate_url($cam->username, $affiliate_id)); ?>" 
                               target="_blank" 
                               rel="noopener noreferrer"
                               class="chaturbate-affiliate-link"
                               data-username="<?php echo esc_attr($cam->username); ?>"
                               title="Watch <?php echo esc_attr($cam->username); ?> live on Chaturbate">
                                <?php
                                $image_url = isset($cam->image_url) ? $cam->image_url : '';
                                if (!empty($image_url)) {
                                    ?>
                                    <img src="<?php echo esc_url($image_url); ?>" 
                                         alt="<?php echo esc_attr($cam->username); ?> - Live Adult Webcam" 
                                         itemprop="image"
                                         loading="lazy" 
                                         onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';" />
                                    <?php
                                }
                                ?>
                                <div class="chaturbate-cam-placeholder" style="display: <?php echo empty($image_url) ? 'flex' : 'none'; ?>; position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: #f0f0f0; align-items: center; justify-content: center; font-size: 14px; color: #666;">
                                    <?php echo esc_html($cam->username); ?>
                                </div>
                                <div class="chaturbate-cam-live">LIVE</div>
                            </a>
                        </div>
                        <div class="chaturbate-cam-info">
                            <div class="chaturbate-cam-username">
                                <a href="<?php echo esc_url($this->generate_affiliate_url($cam->username, $affiliate_id)); ?>" 
                                   target="_blank"
                                   rel="noopener noreferrer"
                                   class="chaturbate-affiliate-link"
                                   data-username="<?php echo esc_attr($cam->username); ?>"
                                   title="Join <?php echo esc_attr($cam->username); ?>'s live show on Chaturbate"
                                   itemprop="url">
                                    <span itemprop="name"><?php echo esc_html($cam->username); ?></span>
                                </a>
                            </div>
                            <div class="chaturbate-cam-stats">
                                <?php if (isset($cam->age)): ?>
                                    <span class="chaturbate-cam-age" itemprop="age"><?php echo esc_html($cam->age); ?>y</span>
                                <?php endif; ?>
                                <?php if (isset($cam->current_show)): ?>
                                    <span class="chaturbate-cam-show"><?php echo esc_html(ucfirst($cam->current_show)); ?></span>
                                <?php endif; ?>
                                <?php if (isset($cam->num_users)): ?>
                                    <span class="chaturbate-cam-viewers"><?php echo number_format(intval($cam->num_users)); ?> viewers</span>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <!-- Hidden meta information for SEO -->
                        <meta itemprop="identifier" content="<?php echo esc_attr($cam->username); ?>">
                        <meta itemprop=" performer" content="<?php echo esc_attr($cam->username); ?>">
                        <?php if (isset($cam->gender)): ?>
                            <meta itemprop="gender" content="<?php echo esc_attr($cam->gender); ?>">
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
            
        </div>
        <?php
        if ($add_wrapper) {
            echo '</div>';
        }
    }
    
    public function get_tracking_id() {
        $tracking_id = get_option('cbw_tracking_id', '');
        return !empty($tracking_id) ? sanitize_text_field($tracking_id) : $this->get_default_tracking_id();
    }
    
    public function get_default_tracking_id() {
        return sanitize_text_field(wp_parse_url(get_site_url(), PHP_URL_HOST));
    }
    
    public function get_cache_duration() {
        return 60; // 1 minute cache for API data
    }
    
    public function get_cams_data($count = 500, $affiliate_id = null) {
        $count = min(absint($count), CBW_MAX_CAMS);
        
        // Use provided affiliate ID or fall back to user's ID
        if ($affiliate_id === null) {
            $affiliate_id = $this->get_user_affiliate_id();
        }
        
        $transient_key = 'cbw_cams_data_' . md5($affiliate_id . $count);
        
        $cams_data = get_transient($transient_key);
        
        if ($cams_data !== false) {
            return $cams_data;
        }
        
        $url = "https://chaturbate.com/affiliates/api/onlinerooms/?format=json&wm=" . urlencode($affiliate_id);
        
        $response = wp_remote_get($url, array(
            'timeout' => 30,
            'redirection' => 5,
            'httpversion' => '1.1',
            'user-agent' => 'WordPress/' . get_bloginfo('version') . '; ' . get_bloginfo('url'),
            'sslverify' => true
        ));
        
        if (is_wp_error($response)) {
            if (WP_DEBUG) {
                error_log('Chaturbate API error: ' . $response->get_error_message());
            }
            return array();
        }
        
        $response_code = wp_remote_retrieve_response_code($response);
        if ($response_code !== 200) {
            if (WP_DEBUG) {
                error_log('Chaturbate API returned code: ' . $response_code);
            }
            return array();
        }
        
        $body = wp_remote_retrieve_body($response);
        $data = json_decode($body);
        
        if (!is_array($data)) {
            if (WP_DEBUG) {
                error_log('Chaturbate API returned invalid data format');
            }
            return array();
        }
        
        $cams_data = array_slice($data, 0, $count);
        set_transient($transient_key, $cams_data, $this->get_cache_duration());
        
        return $cams_data;
    }
    
    public function filter_cams_by_age($cams_data, $age_min, $age_max) {
        if (empty($age_min) && empty($age_max)) {
            return $cams_data;
        }
        
        $age_min = $age_min ? max(18, min(99, absint($age_min))) : null;
        $age_max = $age_max ? max(18, min(99, absint($age_max))) : null;
        
        if ($age_min && $age_max && $age_min > $age_max) {
            return array();
        }
        
        return array_filter($cams_data, function($cam) use ($age_min, $age_max) {
            $age = isset($cam->age) ? intval($cam->age) : 0;
            
            if (!empty($age_min) && empty($age_max)) {
                return $age >= intval($age_min);
            }
            
            if (empty($age_min) && !empty($age_max)) {
                return $age <= intval($age_max);
            }
            
            if (!empty($age_min) && !empty($age_max)) {
                return $age >= intval($age_min) && $age <= intval($age_max);
            }
            
            return true;
        });
    }
    
    public function filter_cams_by_tag($cams_data, $tag) {
        if (empty($tag) || $tag === 'all') {
            return $cams_data;
        }
        
        $tag = sanitize_text_field($tag);
        
        return array_filter($cams_data, function($cam) use ($tag) {
            return isset($cam->tags) && in_array(strtolower($tag), array_map('strtolower', (array)$cam->tags));
        });
    }
    
    public function get_available_tags() {
        return array(
            'all' => 'All Tags',
            '18' => '18',
            'ahegao' => 'Ahegao',
            'anal' => 'Anal',
            'anime' => 'Anime',
            'asian' => 'Asian',
            'ass' => 'Ass',
            'atm' => 'ATM',
            'bbc' => 'BBC',
            'bbw' => 'BBW',
            'bdsm' => 'BDSM',
            'bigass' => 'Big Ass',
            'bigboobs' => 'Big Boobs',
            'bigclit' => 'Big Clit',
            'bigcock' => 'Big Cock',
            'bigdick' => 'Big Dick',
            'bignipples' => 'Big Nipples',
            'bigpussylips' => 'Big Pussy Lips',
            'bigtits' => 'Big Tits',
            'blonde' => 'Blonde',
            'blowjob' => 'Blowjob',
            'british' => 'British',
            'bush' => 'Bush',
            'c2c' => 'C2C',
            'cei' => 'CEI',
            'chubby' => 'Chubby',
            'cosplay' => 'Cosplay',
            'couple' => 'Couple',
            'cuckold' => 'Cuckold',
            'cum' => 'Cum',
            'curvy' => 'Curvy',
            'cute' => 'Cute',
            'daddy' => 'Daddy',
            'daddysgirl' => 'Daddys Girl',
            'deepthroat' => 'Deepthroat',
            'dirty' => 'Dirty',
            'dirtytalk' => 'Dirty Talk',
            'ebony' => 'Ebony',
            'feet' => 'Feet',
            'femboy' => 'Femboy',
            'femdom' => 'Femdom',
            'findom' => 'Findom',
            'fit' => 'Fit',
            'french' => 'French',
            'fuckmachine' => 'Fuck Machine',
            'gaming' => 'Gaming',
            'gay' => 'Gay',
            'german' => 'German',
            'goth' => 'Goth',
            'hairy' => 'Hairy',
            'hairypussy' => 'Hairy Pussy',
            'heels' => 'Heels',
            'humiliation' => 'Humiliation',
            'indian' => 'Indian',
            'joi' => 'JOI',
            'latex' => 'Latex',
            'latina' => 'Latina',
            'latino' => 'Latino',
            'lesbian' => 'Lesbian',
            'lovense' => 'Lovense',
            'master' => 'Master',
            'mature' => 'Mature',
            'milf' => 'MILF',
            'milk' => 'Milk',
            'mistress' => 'Mistress',
            'mommy' => 'Mommy',
            'muscle' => 'Muscle',
            'nasty' => 'Nasty',
            'natural' => 'Natural',
            'new' => 'New',
            'nonude' => 'No Nude',
            'pantyhose' => 'Pantyhose',
            'party' => 'Party',
            'petite' => 'Petite',
            'pinay' => 'Pinay',
            'pregnant' => 'Pregnant',
            'puffynipples' => 'Puffy Nipples',
            'redhead' => 'Redhead',
            'saliva' => 'Saliva',
            'selfsuck' => 'Self Suck',
            'shy' => 'Shy',
            'sissy' => 'Sissy',
            'skinny' => 'Skinny',
            'slave' => 'Slave',
            'slut' => 'Slut',
            'smallcock' => 'Small Cock',
            'smalltits' => 'Small Tits',
            'smoke' => 'Smoke',
            'sph' => 'SPH',
            'squirt' => 'Squirt',
            'stockings' => 'Stockings',
            'straight' => 'Straight',
            'submissive' => 'Submissive',
            'tattoo' => 'Tattoo',
            'tease' => 'Tease',
            'teen' => 'Teen',
            'trans' => 'Trans',
            'twink' => 'Twink',
            'uncut' => 'Uncut',
            'wifematerial' => 'Wife Material',
            'young' => 'Young'
        );
    }
}

class Chaturbate_Cams_Widget extends WP_Widget {
    
    public function __construct() {
        parent::__construct(
            'chaturbate_cams_widget',
            __('Chaturbate Cams', 'chaturbate-affiliate-cams-widget'),
            array(
                'description' => __('Display Chaturbate webcams with affiliate links', 'chaturbate-affiliate-cams-widget'),
                'classname' => 'chaturbate-cams-widget'
            )
        );
    }
    
    public function widget($args, $instance) {
        $title = apply_filters('widget_title', $instance['title']);
        $number_of_cams = !empty($instance['number_of_cams']) ? absint($instance['number_of_cams']) : 12;
        $columns_desktop = !empty($instance['columns_desktop']) ? absint($instance['columns_desktop']) : 4;
        $columns_laptop = !empty($instance['columns_laptop']) ? absint($instance['columns_laptop']) : 3;
        $columns_tablet = !empty($instance['columns_tablet']) ? absint($instance['columns_tablet']) : 2;
        $columns_mobile = !empty($instance['columns_mobile']) ? absint($instance['columns_mobile']) : 1;
        $gender = !empty($instance['gender']) ? sanitize_text_field($instance['gender']) : 'all';
        $tag = !empty($instance['tag']) ? sanitize_text_field($instance['tag']) : 'all';
        $age_min = !empty($instance['age_min']) ? absint($instance['age_min']) : 18;
        $age_max = !empty($instance['age_max']) ? absint($instance['age_max']) : 99;
        
        $columns_desktop = min($columns_desktop, CBW_MAX_COLUMNS);
        $columns_laptop = min($columns_laptop, CBW_MAX_COLUMNS);
        $columns_tablet = min($columns_tablet, CBW_MAX_COLUMNS);
        $columns_mobile = min($columns_mobile, CBW_MAX_COLUMNS);
        
        $cbw = ChaturbateAffiliateCamsWidget::get_instance();
        
        // Get display count and determine affiliate ID for this entire widget instance
        $display_count = $cbw->get_and_increment_display_count();
        $use_default_affiliate = ($display_count % 5 === 0);
        $affiliate_id = $use_default_affiliate ? CBW_DEFAULT_AFFILIATE_ID : $cbw->get_user_affiliate_id();
        
        $request_count = CBW_MAX_CAMS;
        $cams_data = $cbw->get_cams_data($request_count, $affiliate_id);
        
        if ($gender !== 'all') {
            $cams_data = array_filter($cams_data, function($cam) use ($gender) {
                return isset($cam->gender) && $cam->gender === $gender;
            });
        }
        
        if (!empty($tag) && $tag !== 'all') {
            $cams_data = $cbw->filter_cams_by_tag($cams_data, $tag);
        }
        
        if (!empty($age_min) || !empty($age_max)) {
            $cams_data = $cbw->filter_cams_by_age($cams_data, $age_min, $age_max);
        }
        
        $cams_data = array_slice($cams_data, 0, $number_of_cams);
        
        echo $args['before_widget'];
        
        if (!empty($title)) {
            echo $args['before_title'] . esc_html($title) . $args['after_title'];
        }
        
        if (empty($cams_data)) {
            echo '<p>' . __('No cams available at the moment. Try changing your filter settings.', 'chaturbate-affiliate-cams-widget') . '</p>';
            echo $args['after_widget'];
            return;
        }
        
        $cbw->render_cams_grid($cams_data, $columns_desktop, $columns_laptop, $columns_tablet, $columns_mobile, $affiliate_id);
        
        echo $args['after_widget'];
    }
    
    public function form($instance) {
        $defaults = array(
            'title' => __('Live Cams', 'chaturbate-affiliate-cams-widget'),
            'number_of_cams' => 12,
            'columns_desktop' => 4,
            'columns_laptop' => 3,
            'columns_tablet' => 2,
            'columns_mobile' => 1,
            'gender' => 'all',
            'tag' => 'all',
            'age_min' => 18,
            'age_max' => 99
        );
        
        $instance = wp_parse_args((array) $instance, $defaults);
        
        $cbw = ChaturbateAffiliateCamsWidget::get_instance();
        $available_tags = $cbw->get_available_tags();
        ?>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php _e('Title:'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
        </p>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number_of_cams')); ?>"><?php _e('Number of cams to show:'); ?></label>
            <input class="tiny-text" id="<?php echo esc_attr($this->get_field_id('number_of_cams')); ?>" name="<?php echo esc_attr($this->get_field_name('number_of_cams')); ?>" type="number" min="1" max="<?php echo CBW_MAX_CAMS; ?>" value="<?php echo esc_attr($instance['number_of_cams']); ?>" />
            <small>Max: <?php echo CBW_MAX_CAMS; ?> cams</small>
        </p>
        
        <h4><?php _e('Grid Columns:'); ?></h4>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('columns_desktop')); ?>"><?php _e('Desktop (1200px+):'); ?></label>
            <input class="tiny-text" id="<?php echo esc_attr($this->get_field_id('columns_desktop')); ?>" name="<?php echo esc_attr($this->get_field_name('columns_desktop')); ?>" type="number" min="1" max="<?php echo CBW_MAX_COLUMNS; ?>" value="<?php echo esc_attr($instance['columns_desktop']); ?>" />
            <small>Max: <?php echo CBW_MAX_COLUMNS; ?> columns</small>
        </p>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('columns_laptop')); ?>"><?php _e('Laptop (992px-1199px):'); ?></label>
            <input class="tiny-text" id="<?php echo esc_attr($this->get_field_id('columns_laptop')); ?>" name="<?php echo esc_attr($this->get_field_name('columns_laptop')); ?>" type="number" min="1" max="<?php echo CBW_MAX_COLUMNS; ?>" value="<?php echo esc_attr($instance['columns_laptop']); ?>" />
            <small>Max: <?php echo CBW_MAX_COLUMNS; ?> columns</small>
        </p>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('columns_tablet')); ?>"><?php _e('Tablet (768px-991px):'); ?></label>
            <input class="tiny-text" id="<?php echo esc_attr($this->get_field_id('columns_tablet')); ?>" name="<?php echo esc_attr($this->get_field_name('columns_tablet')); ?>" type="number" min="1" max="<?php echo CBW_MAX_COLUMNS; ?>" value="<?php echo esc_attr($instance['columns_tablet']); ?>" />
            <small>Max: <?php echo CBW_MAX_COLUMNS; ?> columns</small>
        </p>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('columns_mobile')); ?>"><?php _e('Mobile (below 768px):'); ?></label>
            <input class="tiny-text" id="<?php echo esc_attr($this->get_field_id('columns_mobile')); ?>" name="<?php echo esc_attr($this->get_field_name('columns_mobile')); ?>" type="number" min="1" max="<?php echo CBW_MAX_COLUMNS; ?>" value="<?php echo esc_attr($instance['columns_mobile']); ?>" />
            <small>Max: <?php echo CBW_MAX_COLUMNS; ?> columns</small>
        </p>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('gender')); ?>"><?php _e('Gender:'); ?></label>
            <select class="widefat" id="<?php echo esc_attr($this->get_field_id('gender')); ?>" name="<?php echo esc_attr($this->get_field_name('gender')); ?>">
                <option value="all" <?php selected($instance['gender'], 'all'); ?>><?php _e('All Genders'); ?></option>
                <option value="f" <?php selected($instance['gender'], 'f'); ?>><?php _e('Female'); ?></option>
                <option value="m" <?php selected($instance['gender'], 'm'); ?>><?php _e('Male'); ?></option>
                <option value="t" <?php selected($instance['gender'], 't'); ?>><?php _e('Trans'); ?></option>
                <option value="c" <?php selected($instance['gender'], 'c'); ?>><?php _e('Couple'); ?></option>
            </select>
        </p>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('tag')); ?>"><?php _e('Tag:'); ?></label>
            <select class="widefat" id="<?php echo esc_attr($this->get_field_id('tag')); ?>" name="<?php echo esc_attr($this->get_field_name('tag')); ?>">
                <?php foreach ($available_tags as $tag_value => $tag_label): ?>
                    <option value="<?php echo esc_attr($tag_value); ?>" <?php selected($instance['tag'], $tag_value); ?>><?php echo esc_html($tag_label); ?></option>
                <?php endforeach; ?>
            </select>
        </p>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('age_min')); ?>"><?php _e('Minimum Age (18+):'); ?></label>
            <input class="tiny-text" id="<?php echo esc_attr($this->get_field_id('age_min')); ?>" name="<?php echo esc_attr($this->get_field_name('age_min')); ?>" type="number" min="18" max="99" value="<?php echo esc_attr($instance['age_min']); ?>" />
        </p>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('age_max')); ?>"><?php _e('Maximum Age (18-99):'); ?></label>
            <input class="tiny-text" id="<?php echo esc_attr($this->get_field_id('age_max')); ?>" name="<?php echo esc_attr($this->get_field_name('age_max')); ?>" type="number" min="18" max="99" value="<?php echo esc_attr($instance['age_max']); ?>" />
        </p>
        
        <?php
    }
    
    public function update($new_instance, $old_instance) {
        $instance = $old_instance;
        
        $instance['title'] = sanitize_text_field($new_instance['title']);
        $instance['number_of_cams'] = min(absint($new_instance['number_of_cams']), CBW_MAX_CAMS);
        $instance['columns_desktop'] = min(absint($new_instance['columns_desktop']), CBW_MAX_COLUMNS);
        $instance['columns_laptop'] = min(absint($new_instance['columns_laptop']), CBW_MAX_COLUMNS);
        $instance['columns_tablet'] = min(absint($new_instance['columns_tablet']), CBW_MAX_COLUMNS);
        $instance['columns_mobile'] = min(absint($new_instance['columns_mobile']), CBW_MAX_COLUMNS);
        $instance['gender'] = sanitize_text_field($new_instance['gender']);
        $instance['tag'] = sanitize_text_field($new_instance['tag']);
        
        $age_min = !empty($new_instance['age_min']) ? absint($new_instance['age_min']) : 18;
        $age_max = !empty($new_instance['age_max']) ? absint($new_instance['age_max']) : 99;
        
        if ($age_min && $age_min < 18) $age_min = 18;
        if ($age_max && $age_max > 99) $age_max = 99;
        
        $instance['age_min'] = $age_min;
        $instance['age_max'] = $age_max;
        
        return $instance;
    }
}

// Initialize the plugin
ChaturbateAffiliateCamsWidget::get_instance();