// pagination.js - Pagination for shortcodes
(function($) {
    "use strict";
    
    function initPagination() {
        $('.chaturbate-cams-paginated').each(function() {
            var $container = $(this);
            var containerId = $container.attr('id');
            var $pagination = $('.chaturbate-pagination[data-container="' + containerId + '"]');
            
            if ($pagination.length === 0) return;
            
            // Remove existing handlers and add new ones
            $pagination.off('click.pagination').on('click.pagination', '.chaturbate-page-btn', function(e) {
                e.preventDefault();
                var $btn = $(this);
                var page = $btn.data('page');
                
                // Update active button
                $pagination.find('.chaturbate-page-btn').removeClass('active');
                $btn.addClass('active');
                
                // Show selected page
                $container.find('.chaturbate-cams-page').removeClass('active');
                $container.find('.chaturbate-cams-page[data-page="' + page + '"]').addClass('active');
                
                // Scroll to top of the page
                $('html, body').animate({
                    scrollTop: 0
                }, 300);
                
                // Count this page view for rotation
                countPageView();
            });
        });
    }
    
    function countPageView() {
        // Use AJAX to increment the display count for rotation
        if (typeof cbw_ajax !== 'undefined' && cbw_ajax.url) {
            $.ajax({
                url: cbw_ajax.url,
                type: 'POST',
                data: {
                    action: 'cbw_increment_display_count',
                    nonce: cbw_ajax.nonce
                }
            });
        }
    }
    
    // Initialize when document is ready
    $(document).ready(function() {
        initPagination();
    });
    
    // Re-initialize after AJAX or dynamic content loads
    $(document).ajaxComplete(function() {
        setTimeout(initPagination, 100);
    });
    
})(jQuery);