// widget.js - Simplified without click tracking
(function($) {
    "use strict";

    $(document).ready(function() {
        // Simple image error handling
        $(".chaturbate-cam-thumbnail img").on("error", function() {
            var $img = $(this);
            $img.hide();
            $img.siblings('.chaturbate-cam-placeholder').show();
        });

        // Add cache-busting parameters only to images, not affiliate links
        function addCacheBusting() {
            $('.chaturbate-cam-thumbnail img').each(function() {
                var $img = $(this);
                var currentSrc = $img.attr('src');
                if (currentSrc && currentSrc.indexOf('cb_nocache') === -1) {
                    var separator = currentSrc.indexOf('?') === -1 ? '?' : '&';
                    $img.attr('src', currentSrc + separator + 'cb_nocache=' + Date.now());
                }
            });
        }

        // Initial cache busting
        addCacheBusting();
    });
})(jQuery);